
from asyncio import sleep
import socket
from PyRunner.urpc_enum.measurementparameter import MeasurementParameter
from PyRunner.virtualunits.vu_measurement_unit import VUMeasurementUnit

from PyRunner.meas_services.instrument import InstrumentService
from PyRunner.urpc_enum.measurementparameter import MeasurementParameter
from PyRunner.jrpc_data.instrumentconfiguration import InstrumentConfiguration
from fleming.system_test.fle_sys import fan_pwm, p_on
# from fleming.common.firmware_util import fan_pwm

from py_pli.pylib import VUnits

import PyRunner.config_enum.detector_aperture_slider_enum as detect_aperture_enum
import PyRunner.config_enum.measurement_unit_enum as meas_unit_enum
import PyRunner.config_enum.scan_table_enum as scan_table_enum
import PyRunner.config_enum.bottom_light_director_enum as bld_enum
import PyRunner.config_enum.filter_module_slider_enum as fms_enum
import PyRunner.config_enum.excitationlight_selector_enum as els_enum

from fleming.hta.myNumPy import *



meas_unit = VUnits.instance.hal.measurementUnit

els = VUnits.instance.hal.excitationLightSelector
fms = VUnits.instance.hal.filterModuleSlider
fm = VUnits.instance.hal.focusMover
scan_table = VUnits.instance.hal.scan_table
das1 = VUnits.instance.hal.detectorApertureSlider1
das2 = VUnits.instance.hal.detectorApertureSlider2
bld = VUnits.instance.hal.bottomLightDirector
pd = VUnits.instance.hal.plateDoor


temperature_sensors=VUnits.instance.hal.temperature_sensors
instrument_service = InstrumentService(hal=VUnits.instance.hal)


# fleming.hta.fleming_measurement.get_all_mover_positions
async def get_all_mover_positions(mode='props'): # 'props','dict'
    els_pos = round(await els.GetPosition(), 3)
    fms_pos = round(await fms.GetPosition(), 3)
    fm_pos = round(await fm.GetPosition(), 3)
    st_pos = [round(x,3) for x in list(await scan_table.GetPosition())]
    das1_pos = round(await das1.GetPosition(), 3)
    das2_pos = round(await das2.GetPosition(), 3)
    bld_pos = round(await bld.GetPosition(), 3)
    pd_pos = round(await pd.GetPosition(), 3)
    
    re = var2dict(bld_pos,els_pos,fm_pos,fms_pos,st_pos,das1_pos,das2_pos,pd_pos)
    return re



async def get_parameter_list():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    dl1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1DiscriminatorLevel)
    for attribute, value in MeasurementParameter.__dict__.items():
        print(attribute,value)
    return

async def focusMove(v): # kaleido height
    await VUnits.instance.hal.focusMover.GotoFocusHeight(v)
    # GetFocusHeightPos
           
async def readBCR():
    res=await instrument_service.ScanFilterModules()
    print(res)
    return    


async def openPlateDoor():
    pd=VUnits.instance.hal.plateDoor
    await pd.Open()

async def closePlateDoor():
    pd=VUnits.instance.hal.plateDoor
    await pd.Close()


async def coolingControl(t=25.0):
    c1= await pmt1_target_temp(t)
    c2 =await pmt2_target_temp(t)
    # await cooling(0,0)
    # time.sleep(0.2)
    # await cooling(1,1)
    # time.sleep(0.2)
    return [c1,c2]

    
# example:     
# print(await get_parameter("PMT1HighVoltageSetting"))
async def get_parameter(name):
    # name="PMT1HighVoltageSetting"
    return await meas_unit.endpoint.GetParameter(getattr(MeasurementParameter,name))
    
async def set_parameter(name,v):
    await meas_unit.endpoint.SetParameter(getattr(MeasurementParameter,name), v)
    
async def apertures(aper1,aper2): # -1:1.6; 0: close; 1:3
    as1 = VUnits.instance.hal.detectorApertureSlider1
    as2 = VUnits.instance.hal.detectorApertureSlider2
    
    if aper1 == 0:
        await as1.Home()
        #print("aperture 1 closed")
    elif aper1 == -1:
        await as1.MoveTo16Pos()
        #print("aperture 1: 16")
    elif aper1 ==  1:
        await as1.MoveTo30Pos()
        # return "aperture 1: 30"
    elif aper1 == 2:
        print("not implemented")
    else:
        print("wrong position for Aerture 1!\n") 
    
    if aper2 == 0:
        await as2.Home()
        #print("aperture 2 closed")
    elif aper2 == -1:
        await as2.MoveTo16Pos()
        #print("aperture 2: 16")
    elif aper2 ==  1:
        await as2.MoveTo30Pos()
        #return "aperture 2: 30"
    elif aper1 == 2:
        print("not implemented")
    else:
        print("wrong position for Aerture 2!\n") 
    
async def cooling(ch1_enable=True,ch2_enable=True):
    # py_pli.pylib.VUnits.instance.hal.airVentilation_Cooling.disable()
    await VUnits.instance.hal.pmt_ch1_Cooling.enable(ch1_enable)
    await VUnits.instance.hal.pmt_ch2_Cooling.enable(ch2_enable)
    
async def get_dl():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    dl1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1DiscriminatorLevel)
    dl2 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT2DiscriminatorLevel)
    return list(dl1+dl2)

async def get_hv():
    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT1HighVoltageSetting)
    hv2 = await meas_unit.endpoint.GetParameter(MeasurementParameter.PMT2HighVoltageSetting)
    return list(hv1+hv2)

async def set_hv(v1,v2):
    if (v1>0.71) | (v2>0.71):
        raise Exception('pmt hv setting exceed the limit and might damage the pmt!')

    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT1HighVoltageSetting,v1)
    hv2 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT2HighVoltageSetting,v2)
    return

async def set_dl(v1,v2):
    if (v1>0.4) | (v2>0.4) | (v1<0.2) | (v2<0.2):
        raise Exception('pmt dl setting exceed the limit and might damage the pmt!')

    meas_unit: VUMeasurementUnit = VUnits.instance.hal.measurementUnit
    hv1 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT1DiscriminatorLevel,v1)
    hv2 = await meas_unit.endpoint.SetParameter(MeasurementParameter.PMT2DiscriminatorLevel,v2)
    return

async def pmt_target_c(c=25.0):
    await pmt1_target_temp(c)
    await pmt2_target_temp(c)
    

async def pmt1_target_temp(temperature_C = 25.0):
    pmt_cooling = VUnits.instance.hal.pmt_ch1_Cooling
    # await pmt_cooling.InitializeDevice()
    await pmt_cooling.set_target_temperature(temperature_C)
    await pmt_cooling.enable()
    # read the temperature again
    c = await pmt_cooling.get_parameter_value()
    return c

async def pmt2_target_temp(temperature_C = 25.0):
    pmt_cooling = VUnits.instance.hal.pmt_ch2_Cooling
    # await pmt_cooling.InitializeDevice()
    await pmt_cooling.set_target_temperature(temperature_C)
    await pmt_cooling.enable()
    # read the temperature again
    c = await pmt_cooling.get_parameter_value() 
    return c


async def pmt1_temperature():
    return await VUnits.instance.hal.pmt_ch1_Cooling.get_feedback_value()

async def pmt2_temperature():
    return await VUnits.instance.hal.pmt_ch2_Cooling.get_feedback_value()


async def get_all_temp():
    v= temperature_sensors.get_all_temperature_values()
    pmt1 = VUnits.instance.hal.pmt_ch1_Cooling
    pmt2 = VUnits.instance.hal.pmt_ch2_Cooling
    v['pmt1_temp']=await pmt1.get_feedback_value()
    v['pmt2_temp']=await pmt2.get_feedback_value()
    v['pmt1_workload'] = await pmt1.get_output_value()
    v['pmt2_workload'] = await pmt2.get_output_value()
    return v

async def set_tec_full(*args):
    # pmt1 = VUnits.instance.hal.pmt_ch1_Cooling
    # pmt2 = VUnits.instance.hal.pmt_ch2_Cooling
    # print([await pmt1.get_output_value(), await pmt2.get_output_value()])
    if len(args)<1:
        await set_peltier_workload(ch=1, wl=1.0)
        await set_peltier_workload(ch=2, wl=1.0)
    else:
        wl=args[0]
        await set_peltier_workload(1, wl)
        await set_peltier_workload(2, wl)
    # await sleep(1)
    # print([await pmt1.get_output_value(), await pmt2.get_output_value()]) 
    # as the software temperature cooling is disabled in the tec setting. the readout does not work

async def set_peltier_workload(ch=1, wl=0.3):
    if wl<0 or wl>1:
        print("peltier workload out of range!")
        return
    
    pmt_c = VUnits.instance.hal.pmt_ch2_Cooling
    if ch == 2:
        pmt_c = VUnits.instance.hal.pmt_ch2_Cooling
    else:
        pmt_c = VUnits.instance.hal.pmt_ch1_Cooling

    await pmt_c.disable()
    power=wl*30
    msg = await p_on(ch, power)
    # await pmt_c.enable() # should not be enabled. 

async def set_fan_speed(pwr=0.5):
    fans=['base1', 'base2', 'base3']
    for fan in fans:
        await fan_pwm(fan, int(pwr*100))
    """
    fan_name: base1, base2, base3, int, ext, pc, fl, trf
    pwr: 0...100%
    """


async def fan_speed_switch():    
    c=[0.2,1.0]
    if not hasattr(fan_speed_switch, "counter"):
        fan_speed_switch.counter = 0
    
    await set_fan_speed(c[fan_speed_switch.counter%2])
    print(c[fan_speed_switch.counter%2])
    fan_speed_switch.counter+=1
    print(fan_speed_switch.counter)

async def st_move(x,y):
    st = VUnits.instance.hal.scan_table
    await st.Move(x, y)
    return await st.GetPosition()


# fleming.hta.hw_control.eject
async def eject():
    await apertures(0,0)
    # await st_move(10, 180) #PreLoadPos
    
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Open()    
    print("Plate Door open.")
    await st_move(10, 300) #RightLoadPos
    print(f"Remove Plate")


async def load():
    await st_move(10, 180) #PreLoadPos
    pd = VUnits.instance.hal.plateDoor
    await pd.UseProfile(1)    
    await pd.Close()    



def reload():
    pass